<?php include "header1.php"; ?>
<div id="layoutSidenav">
    <div id="layoutSidenav_content">
        <main>
            <div class="container-fluid px-5 py-4">
                <h1 class="mt-4 text-center">Evaluation of the Effectiveness of Using YouTube as a Learning Media</h1>
                <p class="text-center" style="font-size: 18px;">
                    This system is used to calculate, analyze, and determine the effectiveness of using YouTube as a learning media 
                    for Informatics Engineering students using the Weighted Product (WP) Method.
                </p>
<br><br>
                        <h3 class="mb-0"><i class="fas fa-calculator"></i> Weighted Product (WP) Method</h3>
                    <div class="card-body" style="font-size: 18px; line-height: 1.8;">
                        <p>
                            The Weighted Product (WP) method is a decision-making method used in decision support systems (DSS).
                            This method allows decision-making based on the weighting of various predefined criteria.
                            WP works by multiplying the value of each alternative with the weight assigned to each criterion.
                        </p>
                        <p>
                            Using this method, the effectiveness of YouTube in enhancing students' understanding and selecting the best channel can be analyzed objectively.
                            The steps in the WP method are as follows:
                        </p>

                        <!-- Steps -->
                        <ol>
                            <li>
                                <strong>Determine the criteria and weights to be used as assessment parameters.</strong>
                            </li>
                            <li>
                                <strong>Determine the calculation of relative weight values or weight normalization.</strong><br>
                                The weight of each criterion needs to be normalized so that the total equals 1. Normalization is performed using the formula:
                                <div class="text-center my-3">
                                    <img src="img/1.png" alt="Weight Normalization Formula" width="1200">
                                </div>
                                <ul>
                                    <li><strong>Wj</strong> = Normalized weight</li>
                                    <li><strong>W0</strong> = Initial weight</li>
                                    <li><strong>∑W0</strong> = Total weight of all criteria before normalization</li>
                                </ul>
                            </li>
                            <li>
                                <strong>Calculate the preference value for each alternative vector S.</strong><br>
                                After obtaining the normalized weight values, each alternative is calculated for the vector S (Si) using the formula:
                                <div class="text-center my-3">
                                    <img src="img/2.png" alt="Vector S Formula" width="1200">
                                </div>
                                For the <em>cost</em> attribute, the value X must be raised to a negative power:
                                <div class="text-center my-3">
                                    <img src="img/3.png" alt="Negative Vector S Formula" width="1200">
                                </div>
                                <ul>
                                    <li><strong>∏</strong> = Multiplication operator (Product)</li>
                                    <li><strong>Si</strong> = Total value of the i-th alternative</li>
                                    <li><strong>Xij</strong> = Value of the i-th alternative for the j-th criterion</li>
                                    <li><strong>Wj</strong> = Normalized weight for the j-th criterion</li>
                                </ul>
                            </li>
                            <li>
                                <strong>Calculate the Relative Preference Value (Vi).</strong><br>
                                After obtaining the vector S values, we can calculate the relative preference value (Vi) using the formula:
                                <div class="text-center my-3">
                                    <img src="img/4.png" alt="Vector V Formula" width="1200">
                                </div>
                                <ul>
                                    <li><strong>Vi</strong> = Relative preference value of the i-th alternative</li>
                                    <li><strong>Si</strong> = Vector S value of the i-th alternative</li>
                                    <li><strong>∑Si</strong> = Total S value of all alternatives</li>
                                </ul>
                            </li>
                            <li>
                                <strong>Perform Ranking, Analysis, and Conclusion.</strong><br>
                                After all the Vi values are obtained, the final step is to rank the preference values to get the best ranking 
                                based on the analysis results.
                            </li>
                        </ol>
                    </div>

            </div>
        </main>
    </div>
</div>
